"As Only Angels Can Fall" by "Victor Gijsbers"




Book - Preliminaries

Include Basic Screen Effects by Emily Short.
[Include Basic Help Menu by Emily Short.]
Include Plurality by Emily Short.
Include Simple Chat by Mark Tilford. Use Default Forbid Exiting Conversations.
Include Scheduled Activities by John Clemens.
[Include Conditional Undo by Jesse McGrew.]
Include Custom Library Messages by David Fisher.
Include Pronouns by Ron Newcomb.


Use no scoring, full-length room descriptions.

Use MAX_OBJ_PROP_COUNT of 128. [Because we define way more than 64  properties for persons/monsters!]


Section - Not for Release

When play begins, seed the random-number generator with 23481.


A thing has a number called the badness. The badness of a thing is usually 0.

Section - Miscellaneous Tweaks

[Take all responses]

[We dont' want "take all" to include scenery or persons.]

Rule for deciding whether all includes scenery: it does not.
Rule for deciding whether all includes persons: it does not.

[And the standard library message which tells us there are none at all available has a quite inappropriate exclamation mark.]

Table of custom library messages (continued)
Message Id							Message Text
LibMsg <no objects available>			"There are none at all available."

[I want "x here" to be synonymous to look.]

The here-backdrop is a backdrop. Here-backdrop is everywhere. Understand "here" as the here-backdrop. Instead of examining here-backdrop: try looking.

[This is here just to make testing easier.]

The test key strokes boolean is a truth state that varies. The test key strokes boolean is [true]false.

To test for any key:
	if the test key strokes boolean is true, wait for any key.

[Some style shortcuts.]

To say rpo:
	say "[run paragraph on]".

To say i:
	say "[italic type]".
	
To say r:
	say "[roman type]".

To say b:
	say "[bold type]".

To say pb:
	say "[paragraph break]".

To say lb:
	say "[line break]".
	
To say lbr:
	say "[bracket]".

To say rbr:
	say "[close bracket]".


Section - Dummy variables

First dummy, second dummy, third dummy and fourth dummy are numbers that vary.


Section - Detailer Kind

A detailer is a kind of thing. A detailer is always scenery. [Examining detailers changes the room description. The idea is that you can have a terse room description, which is fleshed out with detail as the player examines more objects.]

A detailer has some text called the current room description text.
A detailer has some text called the detailed room description text.

Before examining a detailer:
	now the current room description text of the noun is the detailed room description text of the noun.

Section - The Status Line

Table of Yourself Status
left	central	  right
"[bold type][location of the player][roman type]"	""	       "Yourself"


Table of Prisoner Status
left	central	  right
"[bold type][location of the player][roman type]"	"[italic type]Blood:[roman type] 10 / 10"	       "The Prisoner"
"Conjunction: Samael; now"	"[italic type]Zeal:[roman type] 10 / 10"	       "[bold type]Frustrated[roman type]"


Rule for constructing the status line:
	if the player is yourself, fill status bar with Table of Yourself Status;
	if the player is the Prisoner, fill status bar with the Table of Prisoner Status;
	rule succeeds.


Volume - Tracking the Long-term State of the Story

[Here we define variables that we will want to refer to non-locally; that is, things that affect later parts of the story. We define them all in one place for ease of reference.]

Part - Player personality

ss_forgiveness is a number that varies. ss_forgiveness is 0. [Raised when the player forgives; lowered when the player condemns.]

Book - Samael

Part - When Play Begins

ss_FirstAngelicQuestion is a number that varies. ss_FirstAngelicQuestion is 0.

[1 = Yes, the angels listen.
2 = No, the angels do not listen.
3 = Maybe, the angels may listen.]

Part - In a Cage Above the Magma

ss_PityOrReason is a number that varies. ss_PityOrReason is 0.

[1 = Reason.
2 = Pity.]



Volume - The Fiction

Section - The Speaker

The speaker is a backdrop. The Speaker is everywhere. Instead of examining the Speaker: say "I am not here in the flesh.".


Book - Samael



Part - When Play Begins

When play begins:
	show the Rilke quote;
	show the introduction;
	ask the first question on angels;
	now the Yes or No Boolean is true;
	now the Yes or No Text is "Please, answer my question--yes, no, maybe.[paragraph break]";
	now the Yes or No Number is 1.

To show the Rilke quote:
	say "[paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break][paragraph break]Who, if I cried out, would hear me among the Angelic Orders?[paragraph break]     -- Rainer Maria Rilke, 'Duino Elegies'[paragraph break][paragraph break][paragraph break][paragraph break]";
	if gs_PlayerHelp is true, say "[italic type](Welcome to this piece of interactive fiction! I, the voice that speaks between brackets and in italics, will teach you how to play this game. Right now, all you have to do is to press any key you like.)[roman type][paragraph break]";
	test for any key;
	clear the screen.
	
	
To show the introduction:
	show the introduction part 1;
	show the introduction part 2;
	show the introduction part 3.

To show the introduction part 1:
	say "Who indeed?[paragraph break]Will it be the Seraphim--highest of Angels, their eyes eternally fixed on their Creator--to whom the cries of my anguish ascend, soft as whispers? Will they hear me and contemplate my existence? For one moment only, their minds soon returning to thoughts of the Divine--for one moment only. It is enough. One moment of understanding, of mercy, of compassion: that is all the redemption I ask for.[paragraph break][paragraph break]";
	if gs_PlayerHelp is true, say "[italic type](While you are playing this game, two voices will speak to you. One of those is me. I'm the Helper. And the other is the voice that spoke above, loudly and clearly and unencumbered by brackets, and that is the voice of... no, he wouldn't like me telling you that.[lb]Oh, and it's not just us talking to you--[r]you[i] will also have to talk to [r]us[i] by typing commands on your keyboard! Does that prospect scare you? To answer, just choose one of the numbers below!)[roman type][paragraph break]";
	run a conversation from c_Helper_1;
	test for any key;
	clear the screen.

c_Helper_1, c_Helper_2, c_Helper_3, c_Helper_4 are chat nodes.

Instead of giving text for c_Helper_1: say "".
Instead of finding responses to c_Helper_1: link to c_Helper_2; link to c_Helper_3; link to c_Helper_4.

Instead of giving link to c_Helper_2: say "Not at all. I do this all the time.[rpo]".
Instead of giving text for c_Helper_2: say "[i](Oh, that's good! You'll feel right at home then. As far as anyone can feel at home in this world you've just stepped into, that is.)[r]".

Instead of giving link to c_Helper_3: say "It doesn't exactly [i]scare[r] me, but I do feel a bit uneasy, yes. I hope I'll be able to understand what I'm supposed to do, and not get stuck.[rpo]".
Instead of giving text for c_Helper_3: say "[i](Don't worry--I'm here to help you, so it really can't go wrong! Just follow my advice, and you'll learn how to navigate this world very quickly.)[r]".

Instead of giving link to c_Helper_4: say "That's none of your business, voice.[rpo]".
Instead of giving text for c_Helper_4: say "[i](Well, no need to be so aggressive! I'm only here to help you, you know?)[r]".


To show the introduction part 2:
	say "I lower my gaze to the visible Heavens. Will it be the Powers, those tireless movers of Celestial bodies, whose eyes fill with tears at the sight of my doom? They halt for one moment only, the space of an indrawn breath, of a tearful sob, for one moment they halt and so do the planets in their crystalline spheres. It suffices. Saturn's malign influence and that of Mars, broken for one instant of pure possibility in which I can escape from the chains of my fate. One chance: that is all the freedom I ask for.[paragraph break][paragraph break]";
	if gs_PlayerHelp is true, say "[italic type](About that other guy... let's just call him 'the Speaker', shall we? You don't really need to know more, and to be honest, I'm afraid to tell you. If the Speaker found out, he would certainly shut me down, and then [bold type]who[italic type] would help you? There's only the Prisoner, and he needs your help more than you need his. Besides, I'm sure you'll figure out the Speaker's identity for yourself, sooner or later.)[roman type][paragraph break]";
	test for any key;
	clear the screen.

To show the introduction part 3:
	say "I go lower still. Earth. Will it be one of the common angels, those graceful guardians of human affairs, who one day glides into my circle of misery? Who picks me up and embraces me, who enfolds me in her radiant wings, and who lets me forget--oh, if only for an instant!--the reds and ashen greys with which pain, fear, hate and loneliness have stained my once-white soul. Who lets me taste, once again, love undiluted. Oh, for one moment only![paragraph break]I do not ask for more. I already ask far too much.[paragraph break][paragraph break]";
	if gs_PlayerHelp is true, say "[italic type](Okay, so far for the introduction. I think you have finally caught the Speaker's attention. All you have to do is press another key, and then he will start talking directly to [bold type]you[italic type]. Better concentrate, because I feel he is going to ask you a difficult question right away!)[roman type][paragraph break]";
	test for any key;
	clear the screen.

To ask the first question on angels:
	say "Ah, but you have arrived, dear reader! I hope my exclamations did not bore you? Come, come and advise me. Your opinions matter more to me, perhaps, than you can imagine--though it be far from me to question the power and extent of your imagination. What do [italic type]you[roman type] think, reader? Who, if I cried out, would hear me among the Angelic Orders? Would anyone? [italic type]Do[roman type] the angels listen when we cry out?".

	
The Introduction is a room. The player is here.

Rule for printing the banner text: 
	if the player is in the Introduction, do nothing instead.

Instead of looking in the Introduction for the first time:
	do nothing instead.



Instead of saying yes when the Yes or No Number is 1:
	say "Yes? Then there may after all be hope for our protagonist--and God knows I have doubted it.[paragraph break]";
	now ss_FirstAngelicQuestion is 1;
	now the Yes or No Boolean is false;
	now the Yes or No Number is 0;
	do the transition to the fiery lake.

Instead of saying no when the Yes or No Number is 1:
	say "No? Then I fear there is no hope for our protagonist--no hope at all.[paragraph break]";
	now ss_FirstAngelicQuestion is 2;
	now the Yes or No Boolean is false;
	now the Yes or No Number is 0;
	do the transition to the fiery lake.

Instead of saying maybe when the Yes or No Number is 1:
	say "Perhaps, yes, perhaps. I hope they do, for otherwise, our protagonist will not have much of a chance.[paragraph break]";
	now ss_FirstAngelicQuestion is 3;
	now the Yes or No Boolean is false;
	now the Yes or No Number is 0;
	do the transition to the fiery lake.


To do the transition to the fiery lake:
	say "But I forget: you have not met him. Come, please, through here. Do not be afraid, even though the place where he resides is quite... special.";
	test for any key;
	clear the screen;
	move the player to A Lake of Boiling Magma;
	now gs_PlayerHelp_Stage is 1. [Setting the right stage in the player help.]


Instead of smelling, tasting or listening to in the introduction:
	say "Nothing.".

Instead of thinking in the Introduction:
	say "That is not useful yet--you hear only your own thoughts.".



Chapter - Yourself

Instead of examining yourself:
	turn off suggestion 5;
	say "You are not here in the flesh.".
	
Instead of taking inventory when the player is yourself:
	say "Your wits, your will, your wisdom--it must suffice.".

First instead of doing anything except preparing, finding responses to, giving text for, giving link to, taking inventory, examining, looking, thinking, smelling, listening to, waiting when the player is yourself and the Yes or No Boolean is false:
		say "You are not here in the flesh.".



Part - A Lake of Boiling Magma

[First scene: Player-sees-the-Lake]

Player-sees-the-lake is a scene. Player-sees-the-lake begins when the player is in A Lake of Boiling Magma for the first turn. Player-sees-the-Lake ends when the cage is in In a Cage above the Magma.



[Now the location itself.]


A Lake of Boiling Magma is a room. "Here, far underground, lies a lake of boiling stone[the current room description text of the magma]. How did it come here? Some sages claim that the mountains have not yet cooled down, that these are the remnants of the original forging. Others tell a different story. They say that after cooling, the Earth is now heating up again--angered by the sins of Man."

The mountains are scenery in A Lake of Boiling Magma. Understand "underground" and "cave" as the mountains.

Instead of examining the mountains:
	say "When the Earth was young, the mountains were forged from molten rock. Have you ever seen a smith at work? Have you seen him take a bar of metal from the fire? It glows with a fierce orange that turns to a dull red as the smith beats it into a blade, the not-quite-liquid metal reluctantly bending beneath the smith's will and the force of the hammer. Those colours and that state of almost-liquidity, that is what the Earth was like before God beat it into shape.";
	turn off suggestion 11.

After looking in A Lake of Boiling Magma for the second time:
	now gs_PlayerHelp_Stage is 3. [Setting the right stage in player help.]

After looking in A Lake of Boiling Magma for the third time:
	turn off suggestion 6.

A detailer called the magma is in the Lake of Boiling Magma. Understand "magma" and "boiling" and "rock" and "stone" and "earth" and "lake" and "molten" and "lava" as the magma. The magma is scenery.

The current room description text of the magma is "".
The detailed room description text of the magma is ", patterns in red and grey unceasingly moving across it".

Instead of examining the magma during Player-sees-the-Lake:
	say "A surface of boiling rock--easier to walk on than water, if you don't mind the heat. See how it forms patterns: an earthly grey where it cools off temporarily, the red of flaming anger where the secret forces of convection have heated it up. Large patterns, ever changing. Are they random? They seem so to us--but the Prisoner has been seeing faces in them, faces that speak, figures that beckon him forward.";
	now gs_PlayerHelp_Stage is 5;
	turn off suggestion 4.

The patterns are part of the magma. Understand "faces" and "figures" and "red" and "grey" and "shifting" as the patterns. The patterns are plural-named.

Instead of examining the patterns during Player-sees-the-Lake:
	say "The patterns form faces and figures, yes. But to see them, you will have to look through the Prisoner's eyes; so have a little patience.";
	turn off suggestion 7. 


The cage is in the Lake of Boiling Magma. "High above, a cage dangles from the ceiling." The cage is fixed in place.

Instead of examining the cage during Player-sees-the-Lake:
	say "How small it looks, this single man-made object in the vastness of the cave, swinging to and fro at the mercy of hot currents of air. The Prisoner sits in it, slumped against the bars. Unmoving.";
	turn off suggestion 8;
	turn on suggestion 10.

The hot currents of air are in the Lake of Boiling Magma. Instead of examining the hot currents of air: say "On the surface between Earth and Air, Fire leaps from the one to the other, continuing its ascent to the sub-lunar heights.". The hot currents of air are scenery and plural-named.


[The prisoner and transition to the Cage]

The Prisoner is a person in the Lake of Boiling Magma. Understand "protagonist" as The Prisoner. The Prisoner is scenery.

Every turn in the Lake of Boiling Magma:
	have the parser notice the Prisoner.

Instead of examining The Prisoner during Player-sees-the-Lake:
	do transition to the cage.

To do transition to the cage:
	say "There he is, locked in a cage, as he has been for almost twelve years. And not just any cage either, as you have already seen: it hangs suspended above a lake of boiling lava, which itself is located in the deepest dungeons of The Citadel.[paragraph break]That he is here proves that this man is dangerous, very dangerous--although you would not say so by looking at him. He has been trying to starve himself to death lately and with some success; it seems as if he is doomed to die within these prison walls.[lb]But don't let appearances deceive you. He is about to escape.";
	test for any key;
	clear the screen;
	say "Come, follow me. We must take a look at him from up close.";
	test for any key;
	repeat with n running from 4 to 12:
		turn off suggestion n; [Suggestions for the first scene turned off]
	repeat with n running from 13 to 15:
		turn on suggestion n; [Suggestions for second scene turned on]
	move the cage to In a Cage above the Magma;
	consider the scene changing rules;
	move the player to In a Cage above the Magma;
	now the cage is scenery;
	move the magma to In a Cage above the Magma;
	move the hot currents of air to In a Cage above the Magma;
	move the Prisoner to In a Cage above the Magma;
	now gs_PlayerHelp_Stage is 6.




[Special actions]

Instead of thinking in the Lake of Boiling Magma:
	say "Not yet--you hear only your own thoughts.".

Instead of smelling in the Lake of Boiling Magma:
	try smelling the hot currents of air.

Instead of smelling the magma:
	try smelling the hot currents of air.

Instead of smelling the hot currents of air when the player is yourself:
	say "A faint smell of sulphur tinges the air.";
	turn off suggestion 9.

Instead of listening to the Lake of Boiling Magma:
	try listening to the magma.

Instead of listening to the magma:
	say "A rumbling sound almost below hearing slowly reverberates through the cavern. It is the beating heart and pumping blood of the Earth.".


Part - In a Cage above the Magma

[Second scene: Meeting-the-Prisoner]

Meeting-the-Prisoner is a scene. Meeting-the-Prisoner begins when Player-sees-the-Lake ends. Meeting-the-Prisoner ends when the player is the prisoner.


[Meta scene: Being-the-Prisoner]

Being-the-Prisoner is a scene. Being-the-Prisoner begins when the player is the prisoner. Being-the-prisoner ends when Samael is enclosed by the location.

Every turn when being-the-prisoner is happening:
	if a random chance of 1 in 4 succeeds, say "The shifting patterns in the magma below catch the Prisoner's attention.".

[Third scene: Speaking-with-Samael]

Speaking-with-Samael is a scene. Speaking-with-Samael begins when being-the-prisoner ends. Speaking-with-Samael ends when Samael is not enclosed by the location.

[Fourth scene: Escaping-the-Cage]

Escaping-the-Cage is a scene. Escaping-the-Cage begins when Speaking-with-Samael ends. Escaping-the-Cage ends when Samael is in In a Cage above the Magma for the first turn.




[The location itself]


A room called In a Cage above the Magma is up from A Lake of Boiling Magma. "[if meeting-the-prisoner is happening]Look at him. Trapped between these bars for more than a decade, with only the shifting patterns in the lava and the daily appearance of food to break the monotony--it would have driven far greater men mad. Of course, had he been entirely sane to begin with, he wouldn't have ended up [italic type]here[roman type][end if][if being-the-prisoner is happening]The Prisoner still sits in the cage that has trapped him for over a decade, a cage high above a lake of ever-burning lava unconsumed. But [italic type]something[roman type] has changed. There is [italic type]hope[roman type] in his mind (for the first time in years), hope of--what? Freedom? Redemption? Revenge? Of nothing yet, really: his mind is still too overwhelmed by the alien feeling to decide on the details. They do not matter. Not yet[end if][if speaking-with-samael is happening]And before him Samael has appeared--in the flesh, or nearly so: a dark, bearded male, an over-towering presence whose furrowed forehead bears witness to deep inhuman griefs. No Man is he, but something more, something that has known pain, and hate, and fear, and doubt, all beyond the measure of men. But he looks down on the Prisoner not in hate or anger, but with true love and compassion[end if]."


[Magma revisited]

Instead of examining the magma in In a cage above the Magma:
	if the player is yourself:
		turn off suggestion 14;
		 say "Far below, the magma boils and churns. See how it forms patterns: an earthly grey where it cools off temporarily, the red of flaming anger where the secret forced of convection have heated it up. Large patterns, ever changing. Are they random? They seem so to us--but [italic type]he[roman type] has been seeing faces in them, faces that speak, figures that beckon him forward.";
	if the player is the Prisoner, say "Far below, the magma boils and churns. Its patterns, which once mocked him with their very impersonality, now form four figures familiar through an acquaintance of months--they are the four gods Samael, Astarte, Iblis and Na'amah. He looks at them with a mixture of awe and fear; they are his only hope, but he does not yet trust them.".


[The cage revisited]

Instead of examining the cage in In a cage above the Magma:
	turn off suggestion 15;
	say "These are the bars that have held him captive for all the long years of his imprisonment, the bars that cut him off from Life by denying him escape, and from Death by keeping him from jumping into the magma below. The cage makes slow movements as the currents shift; it hangs from the ceiling by an adamantine chain.".
	
Instead of attacking the cage in In a Cage above the Magma:
	try attacking the bars.


[Currents of air revisited]

Instead of smelling the hot currents of air when the player is The Prisoner:
	say "He sniffs, but the smells of hot air and sulphur have embedded themselves so permanently in his nose that he can longer discern them.".


[The bars.]

The bars are in In a Cage above the Magma. The bars are scenery.

Instead of examining the bars:
	if Escaping-the-Cage is happening begin;
		if the bars are handled, say "Free at last! He cannot yet believe it; he thinks that he must be dreaming as he looks at the bended and broken bars in stupefaction."; [We set the bars to handled once they have been smashed.]
		if the bars are not handled, say "For years they were the most solid and inert things on Earth, the very shackles of necessity. Now, after Samael's words and instruction, they shine with possibility.";
	otherwise;
		turn off suggestion 17;
		say "How many times did he look at them in hate? How many times did he curse them for their strength and thickness, enraged only more by their stupid, insensible silence, by the fact that they are as blameless as only things can be? He longs to destroy them, that much is certain.";
	end if.

Instead of attacking the bars:
	turn off suggestion 21;
	if Escaping-the-Cage is happening begin;
		if the bars are handled, say "The bars have been smashed. Freedom is his!"; [We set the bars to handled once they have been smashed.]
		if the bars are not handled, say "He has attacked the bars countless times before. Today, he must perform a different feat--he must the powers granted by Samael and [italic type]smash[roman type] them.";
	otherwise;
		say "He raises his hand, but he knows all too well what would happen: nothing. A dull pain is his knuckles would be his only reward; and the time when he sought that sensation in order to feel at least a little bit alive is long past.";
	end if.

[Hope]

Hope is a thing. It is scenery.

Instead of examining hope during Being-the-Prisoner:
	say "Still vague and undefined. He dares not yet hope for escape.".

Instead of taking hope:
	say "Good advice, but mere words will not help him.".

[The patterns revisited]

Instead of examining the patterns during Meeting-the-Prisoner:
	turn off suggestion 19;
	say "The patterns form faces--or at least, [italic type]he[roman type] has been seeing faces in the patterns. They were the faces on angels, and they spoke to him in his dreams. Have patience; for very soon you will be able to look at them through his eyes.".
	
Instead of examining the patterns during Being-the-Prisoner:
	turn off suggestion 19;
	run a conversation from c_Faces_1;
	schedule making Samael appear in 1 minute.

Instead of examining the patterns during Speaking-with-Samael:
	say "He no longer needs to look at the lava to see the face of Samael, for it is right before him in its dazzling glory.".
	
Instead of examining the patterns during Escaping-the-Cage:
	say "How quickly do our minds change with the circumstances: the patterns at which he once looked obsessively no longer hold even the slightest interest for him. His whole consciousness is filled with the prospect of freedom.".



[The faces of angels.]

c_Faces_1, c_Faces_2, c_Faces_3, c_Faces_4, c_Faces_5, c_Faces_6 are chat nodes.

Instead of giving text for c_Faces_1: say "He stares down into the lava. Its reds and yellows swirl and twist until they form the faces of angels--the face, first, of Samael; then of Astarte; of Iblis; and finally that of cowled Na'amah.".
Instead of finding responses to c_Faces_1: link to c_Faces_2; link to c_Faces_3; link to c_Faces_4; link to c_Faces_5; link to c_Faces_6.

Instead of giving link to c_Faces_2: say "Direct the Prisoner's attention to the face of Samael.[rpo]".
Instead of giving text for c_Faces_2: say "The image of Samael appears in the boiling lava: a dark, bearded man, his forehead furrowed by grief, but his face still radiant with an unearthly compassion. When he spoke to the prisoner, his words were melancholy and grave, for Samael carries a heavy burden of knowledge--and yet, he spoke only of hope."; deactivate c_Faces_2.
Instead of finding responses to c_Faces_2: link to c_Faces_2; link to c_Faces_3; link to c_Faces_4; link to c_Faces_5; link to c_Faces_6.

Instead of giving link to c_Faces_3: say "Direct the Prisoner's attention to the face of Astarte.[rpo]".
Instead of giving text for c_Faces_3: say "Astarte, lady noble and elect! The shining and radiant Astarte, Princess of Joy and Queen of Sorrow. Oft has he dreamed of her, of her welcoming arms and her loving smile--that smile that always seems about to turn into a surprised gasp of pain."; deactivate c_Faces_3.
Instead of finding responses to c_Faces_3: link to c_Faces_2; link to c_Faces_3; link to c_Faces_4; link to c_Faces_5; link to c_Faces_6.

Instead of giving link to c_Faces_4: say "Direct the Prisoner's attention to the face of Iblis.[rpo]".
Instead of giving text for c_Faces_4: say "The glowing magma shows a young and smiling man, if 'man' is the word for this being made of smokeless fire. Full of fun and wit, ironic and incapable of taking the world seriously, his appearances kept the Prisoner sane without giving him comfort."; deactivate c_Faces_4.
Instead of finding responses to c_Faces_4: link to c_Faces_2; link to c_Faces_3; link to c_Faces_4; link to c_Faces_5; link to c_Faces_6.

Instead of giving link to c_Faces_5: say "Direct the Prisoner's attention to the face of Na'amah.[rpo]".
Instead of giving text for c_Faces_5: say "Her face cannot be seen. Clad in a monkish robe, cowled always, we never perceive more than her melodious voice--but the knowledge and wisdom which that voice carries into the hearts of men can nourish even the greatest of minds."; deactivate c_Faces_5.
Instead of finding responses to c_Faces_5: link to c_Faces_2; link to c_Faces_3; link to c_Faces_4; link to c_Faces_5; link to c_Faces_6.

Instead of giving link to c_Faces_6: say "Look elsewhere.[rpo]".
Instead of giving text for c_Faces_6: try looking. [To be changed.]


[The prisoner revisited]

Instead of examining the prisoner during Meeting-the-Prisoner:
	turn off suggestion 13;
	say "Look at his body. See how little flesh there is on his bones, how deep his closed eyes lie in their sockets; see how pale his skin is and how sickly his complexion. His hair is thin, unwashed, uncombed. His beard, long and unkempt. His naked body stinks, as if it has already begun to decay.".

Understand "flesh" and "bones" and "eyes" and "sockets" and "skin" and "complexion" and "hair" and "beard" and "naked" and "body" as the prisoner.

Instead of smelling the prisoner during Meeting-the-Prisoner:
	turn off suggestion 16;
	say "The foul stench of excrement tinged with the seductive aroma of death.".

Instead of smelling a room during Meeting-the-Prisoner:
	say "Odours come from the prisoner's body: the foul stench of excrement and the seductive aroma of death.".

Instead of examining the prisoner:
	turn off suggestion 22;
	say "He glances at his gaunt body with indifference. He has forgotten how heroic he once looked[one of]. Only I remember how his big muscles once gleamed in the setting sun atop Coronation Hill, how his movements were once sure and fearless, how in his eyes there gleamed an all-encompassing love of life! Lost, all lost[or][stopping].".

[Whispered words]

The whispered words are scenery in In a Cage above the Magma. Understand "whisper" and "whispers" and "voice" and "dreams" as the whispered words. Instead of examining the whispered words: say "Your eyes detect no patterns in the air." Instead of listening to the whispered words: try listening to the prisoner.


[Listening to the prisoner]

[The flow is like this:

1. Any actions.
2. Listen. (or listen to the prisoner, to the words.)
3. Answer the question whether you can hear him.
4. Play through the conversation.
5. Any actions.

In the intermediate states 2-3, we don't want the player to do anything but answer the question or listen to the prisoner. We check for this by setting ss_ListenToPrisoner to true and the Yes or No Boolean to true at step 2. Step 3 resets the Yes or No Boolean. Step 4 resets ss_ListenToPrisoner.]


Instead of listening to in In a Cage above the Magma for the first time:
	say "Please, bend forward, towards this wretched body, until your ear almost touches his lips. Can you catch the faint sound of his whispers? Can you understand what he says?";
	turn off suggestion 18;
	now gs_PlayerHelp_Stage is 8;
	now the Yes or No Boolean is true;
	now the Yes or No Text is "I ask again: can you hear him?[paragraph break]";
	now the Yes or No Number is 2.

Instead of saying yes when the Yes or No Number is 2:
	say "Good. Now listen carefully to what he says.[paragraph break]";
	now the Yes or No Boolean is false;
	now the Yes or No Number is 0;
	now gs_PlayerHelp_Stage is 9;
	do the prisoner whispers cut-scene.

Instead of saying no when the Yes or No Number is 2:
	say "Then bend closer still--yes, like that. Good. Now listen carefully to what he says.[paragraph break]";
	now the Yes or No Boolean is false;
	now the Yes or No Number is 0;
	now gs_PlayerHelp_Stage is 9.;
	do the prisoner whispers cut-scene

Instead of saying maybe when the Yes or No Number is 2:
	say "Be silent then, and listen carefully to what he says.[paragraph break]";
	now the Yes or No Boolean is false;
	now the Yes or No Number is 0;
	now gs_PlayerHelp_Stage is 9;
	do the prisoner whispers cut-scene.

[Intercepting other action.]

Before doing anything except listening to, saying yes, saying no or saying maybe in In a Cage above the Magma:
	if the Yes or No Boolean is true, say the Yes or No Text instead.


[Timed events that help the player understand she should listen.]

Every turn when the time since Meeting-the-Prisoner began is one minute:
	if Yes or No Boolean is false and the player is yourself:
		turn on suggestion 18;
		say "But listen--whispered words pass over his lips. He speaks of his dreams.".

Every turn when the time since Meeting-the-Prisoner began is three minutes:
	if Yes or No Boolean is false and the player is yourself:
		say "Please listen to the prisoner--he speaks in whispers.".


[Becoming the prisoner / the prisoner whispers cut-scene]

To do the prisoner whispers cut-scene:
	say "'Samael?', he whispers. 'Those footsteps... are they yours? Is that you who approaches me? You have come so often in my dreams--please, come now as I wake. I need you, Samael; you must come now or it will be too late!' Then his whispers fade again into incomprehensible muttering.[paragraph break]I will tell you something personal, reader: the despair in that voice nearly breaks my heart. I have known this man for a long time. You could say that he's a friend of mine, sort of--and I want to help him. Difficult times lie ahead, for him [italic type]and[roman type] for others. A lot will depend on his actions. Anyway; I brought you here in a hurry and without explanations. You must have questions.";
	run a conversation from c_Questions_1;
	change player to the prisoner;
	remove yourself from play;
	change the library message person to third person;
	now gs_PlayerHelp_Stage is 9;
	move hope to In a Cage above the Magma;
	try looking.

[The despair in that voice nearly breaks my heart. But look, reader: he wakes. His hand twitches, his eyes open--and Samael is approaching. I think it is time for you to take on your burden, reader. Help the Prisoner. Direct him! I do not want to make you nervous, but to be quite frank: you are his only hope.]

[c_Questions: A conversation where you can confront the Speaker for the first time.]

c_Questions_1, c_Questions_2, c_Questions_3, c_Questions_4, c_Questions_5, c_Questions_6, c_Questions_7, c_Questions_8, c_Questions_9, c_Questions_10, c_Questions_11, c_Questions_12, c_Questions_13, c_Questions_14, c_Questions_15, c_Questions_16 , c_Questions_17 , c_Questions_18 , c_Questions_19, c_Questions_20, c_Questions_21 are chat nodes.

Instead of preparing c_Questions_5: do nothing.
Instead of preparing c_Questions_6: do nothing.
Instead of preparing c_Questions_9: do nothing.

Instead of giving text for c_Questions_1: now gs_PlayerHelp_Stage is 9.
Instead of finding responses to c_Questions_1: link to c_Questions_2; link to c_Questions_3; link to c_Questions_4.

Instead of giving link to c_Questions_2: say "Who are you and where have you brought me?[rpo]".
Instead of giving text for c_Questions_2: deactivate c_Questions_2; activate c_Questions_5; say "You are in the Citadel of the Lost, a prison fortress that holds the most dangerous men, women and beasts in the Empire (though here those distinctions unravel). The Citadel is built in a location so remote that when a bird reaches the Empire's generals with news of an escape, they still have enough time to field an army and protect our people. Less than an army would not suffice--most certainly not against this man here, if his strength were to return.".
Instead of finding responses to c_Questions_2: link to c_Questions_2; link to c_Questions_5; link to c_Questions_6; link to c_Questions_3; link to c_Questions_4; link to c_Questions_9.


Instead of giving link to c_Questions_3: say "Who is this man whom you call 'the Prisoner'?[rpo]".
Instead of giving text for c_Questions_3: deactivate c_Questions_3; activate c_Questions_9; say "He is, as I said, a friend of mine. He is also a wretched being, on the brink of madness and nearer to death than to life. Just look at his gaunt face, his haunted features--surely you must pity him, even if you do not know him?".
Instead of finding responses to c_Questions_3: link to c_Questions_7; link to c_Questions_8.


Instead of giving link to c_Questions_4: say "What do you want from me, Speaker?[rpo]".
Instead of giving text for c_Questions_4: deactivate c_Questions_4; say "I need you assistance in a delicate matter. To be more precise, the Prisoner here needs your help. Without your guidance, he will die--or worse.".
Instead of finding responses to c_Questions_4: link to c_Questions_2; link to c_Questions_5; link to c_Questions_6; link to c_Questions_3; link to c_Questions_4; link to c_Questions_9.

Instead of giving link to c_Questions_5: say "You answered only half of my question. Who are [i]you[r], Speaker? 'Mr X'? 'The Nameless One'?[rpo]".
Instead of giving text for c_Questions_5: deactivate c_Questions_5; activate c_Questions_6; say "I could say that my identity is unimportant, but that would be a lie. It is in fact essential. But it is of the utmost importance that the Prisoner does not find out who I am, and I know from bitter experience that the best way to keep a secret is not to share it.".
Instead of finding responses to c_Questions_5: link to c_Questions_2; link to c_Questions_5; link to c_Questions_6; link to c_Questions_3; link to c_Questions_4; link to c_Questions_9.

Instead of giving link to c_Questions_6 when second chat node is c_Questions_5: say "So you don't trust me.[rpo]".
Instead of giving link to c_Questions_6: say "But you don't trust me, since you don't want to say who you are.[rpo]".
Instead of giving text for c_Questions_6: deactivate c_Questions_6; say "It's not a matter of trust. Of course I trust you--I'm putting the future of my friend, and in many ways of myself, in your hands! No, I trust you; but the nature of my scheme will make it impossible for you to keep secrets from the Prisoner.".
Instead of finding responses to c_Questions_6: link to c_Questions_2; link to c_Questions_5; link to c_Questions_6; link to c_Questions_3; link to c_Questions_4; link to c_Questions_9.


Instead of giving link to c_Questions_7: say "Listen--I don't know who this guy is, or what he has done, or why he is here. I don't know who you are, and I don't know what you want from me. I want to know what's going on, and [italic type]then[roman type] I'll judge whether any of you deserves pity. My heart doesn't melt at the mere sight of tears.[rpo]".
Instead of giving text for c_Questions_7: now ss_PityOrReason is 1; say "Excellent! You have just passed my first test. I need someone who can think clearly, who can reason without emotions getting in his way. On your journey honeyed tongues will tell lies that you [i]must[r] not believe; you will hear pleas for help that [i]must[r] be ignored. I think you will succeed admirably.".
Instead of finding responses to c_Questions_7: link to c_Questions_2; link to c_Questions_5; link to c_Questions_6; link to c_Questions_3; link to c_Questions_4; link to c_Questions_9.

Instead of giving link to c_Questions_8: say "No matter what a man has done, he does not deserve such treatment. How many years did he spend in this cage? This is not a prison; this is a Hell constructed by men, and this wretched creature has been punished more than can be possibly justified. Yes, I do pity him.[rpo]".
Instead of giving text for c_Questions_8: now ss_PityOrReason is 2; say "Excellent! You have just passed my first test. I need a compassionate person, someone who will do the right thing when he is faced with misery and injustice. Cynicism and apathy will constantly stalk you, and only a kind heart like yours will be able to resist them.".
Instead of finding responses to c_Questions_8: link to c_Questions_2; link to c_Questions_5; link to c_Questions_6; link to c_Questions_3; link to c_Questions_4; link to c_Questions_9.

Instead of giving link to c_Questions_9: say "[if ss_PityOrReason is 1]I've heard enough--tell me what you want me to do [i]now[r], and while you're at it, explain why I would do as you ask. Give me some answers, or I'm off.[otherwise]All right, but I do need some answers now. What exactly is it you want me to do? And why don't you just do it yourself?[end if][rpo]".
Instead of giving text for c_Questions_9: say "I'm coming to that! Relax. You heard the guy talk about Samael, right? This Samael is an angel, and he has been talking to our Prisoner. What's more, I have reasons to believe that he will appear here soon to free him.".
Instead of finding responses to c_Questions_9: link to c_Questions_10.

Instead of giving link to c_Questions_10: say "[if ss_FirstAngelicQuestion is 1]So I was right. T[end if][if ss_FirstAngelicQuestion is 2]I was wrong then. T[end if][if ss_FirstAngelicQuestion is 3]Well, that answers your question: t[end if]he angels [i]do[r] listen to him.[rpo]".
Instead of giving text for c_Questions_10: say "It's not so simple, unfortunately. [i]Did[r] Samael listen to him because he cried out? If that were so, I wouldn't need your help; I could just leave my friend in the hands of the angels. But what if Samael talks to him and manipulates him in order to [i]use[r] him, as a pawn in some celestial game? It has happened before. You must not forget that the Prisoner is a powerful man; even the angels might like to enlist him.".
Instead of finding responses to c_Questions_10: link to c_Questions_11; link to c_Questions_12.

Instead of giving link to c_Questions_11: say "I see what you mean. Even the forces of good sometimes sacrifice individual people.[rpo]".
Instead of giving text for c_Questions_11: say "Indeed. And they may have reasons to choose my friend, for he is a sinner, a murderer even! Oh, they would probably sacrifice him without a second thought, if that fitted into their schemes. What do [i]they[r] care for a stained soul?".
Instead of finding responses to c_Questions_11: link to c_Questions_13; link to c_Questions_14.

Instead of giving link to c_Questions_12: say "I think you worry too much. Surely the angels can wish him no harm.[rpo]".
Instead of giving text for c_Questions_12: say "Ah, but they [i]can[r]. Remember that my friend is here, in this godforsaken prison, for a reason: he is a sinner, a murderer even! Who says that the Heavenly hosts have not decided to destroy him, as punishment? Who says that they want to show him mercy?".
Instead of finding responses to c_Questions_12: link to c_Questions_13; link to c_Questions_14.

Instead of giving link to c_Questions_13: say "I see your point, and I agree: this man ought to be helped. But I don't really see what that has to do with me, specifically.[rpo]".
Instead of giving text for c_Questions_13: say "Thank you. Your support means much to me. So let me explain to you a point that may be somewhat difficult to believe. The point is this: you are the Prisoner.".
Instead of finding responses to c_Questions_13: link to c_Questions_15; link to c_Questions_16.

Instead of giving link to c_Questions_14: say "Wait a minute--if he is a murderer, maybe he deserves his punishment. It might not be such a great idea to position ourselves between a sinner and the righteous wrath of the heavens.[rpo]".
Instead of giving text for c_Questions_14: say "No, how can you say that? Will you deny him the freedom to change? That cannot be so--you too must believe that he can still redeem himself, that he can wash the stains from his soul. You must believe that; especially since you [i]are[r] the Prisoner!".
Instead of finding responses to c_Questions_14: link to c_Questions_15; link to c_Questions_16.

Instead of giving link to c_Questions_15: say "[lbr]Sarcastic[rbr] [i]I[r] am the Prisoner?[rpo]".
Instead of giving text for c_Questions_15: say "I understand that this is hard to believe, but you are. The two of you are not strictly identical, of course; but you are in your world who he is in ours. You are bound to each other by ties older than Creation, ties stronger than death. And that is why only you can help him.".
Instead of finding responses to c_Questions_15: link to c_Questions_17; link to c_Questions_18; link to c_Questions_19.

Instead of giving link to c_Questions_16: say "[lbr]Astonished[rbr] I [i]am[r] the Prisoner?[rpo]".
Instead of giving text for c_Questions_16: say "I understand that this is hard to believe, but you are. The two of you are not strictly identical, of course; but you are in your world who he is in ours. You are bound to each other by ties older than Creation, ties stronger than death. And that is why only you can help him.".
Instead of finding responses to c_Questions_16: link to c_Questions_17; link to c_Questions_18; link to c_Questions_19.

Instead of giving link to c_Questions_17: say "So what you are trying to tell me is that I am in some mysterious metaphysical sense the same person as this naked, filthy guy here, and that [i]that[r] is why I have an obligation to help him?[rpo]".
Instead of giving text for c_Questions_17: say "I did not say that you have an obligation. All I say is that you are the only person who [i]can[r] help him, the only person whose will can coincide with his without using coercion. He needs you. I need you. You are not obliged to help him--but I ask you to do it. Reader, dear reader, will you help the Prisoner?".
Instead of finding responses to c_Questions_17: link to c_TakeControl_2; link to c_TakeControl_3.

Instead of giving link to c_Questions_18: say "Are you insinuating that I am in any way like this person here whom you have just called a murderer? You overstep the bounds of propriety; I do not take kindly to such suggestions.[rpo]".
Instead of giving text for c_Questions_18: say "Ah, how fortunate you must be! You do not feel pangs of anger and hatred when you are faced with cruelty and injustice? Your soul knows no violent impulses, but only the quiet forces of wisdom and mercy? In your breast there do not lie the awful seeds of violence, patiently awaiting the rain of blood that may never come, but that will allow them to bloom into the horrendous flesh-coloured flowers of death if it does? You are indeed to be envied!".
Instead of finding responses to c_Questions_18: link to c_Questions_20; link to c_Questions_21.

Instead of giving link to c_Questions_19: say "I understand. The shackles of a single reality do not hold me; my self cannot be contained to one world, one series of actions, one personality out of all the possible ones I could have adopted. I am large; I contain multitudes. I will manage to encompass the Prisoner.[rpo]".
Instead of giving text for c_Questions_19: increase ss_forgiveness by 1; say "Well spoken! You are even more promising material than I hoped; though you shouldn't allow that magnanimous attitude of your to include the many evil individuals that you will meet on the journey that lies before you. For I assume that you will take on the task of guiding him?".
Instead of finding responses to c_Questions_19: link to c_TakeControl_2; link to c_TakeControl_3.

Instead of giving link to c_Questions_20: say "You are right. I am not a murderer, but I could have been one. I might even become one, if the circumstances were right. Too quickly did I condemn this man; he need not be a monster any more than I am.[rpo]".
Instead of giving text for c_Questions_20: increase ss_forgiveness by 1; say "You are a wise man, or a wise woman; for it is a sign of wisdom to admit to one's mistakes. I assume, then, that you will take on the task of guiding the Prisoner?".
Instead of finding responses to c_Questions_20: link to c_TakeControl_2; link to c_TakeControl_3.

Instead of giving link to c_Questions_21: say "Spare me your thinly disguised relativism. As if there are no better and worse human beings. 'Forgiveness' is a nice concept, but if nobody throws the first stone, all crime goes unpunished. No, you can talk what you wish, but I will throw stones whenever I wish. It's the only [i]practical[r] way of leading one's life.[rpo]".
Instead of giving text for c_Questions_21: decrease ss_forgiveness by 1; say "Your inflated self-image impresses me not in the least, so save your grandiloquent rhetoric for other. Anyway, it does not matter. We need not like each other. The only relevant question is: will you help the Prisoner? Will you guide him?".
Instead of finding responses to c_Questions_21: link to c_TakeControl_2; link to c_TakeControl_3.



[c_TakeControl:

A conversation about being the only hope of the Prisoner.]

c_TakeControl_2, c_TakeControl_3, c_TakeControl_4, c_TakeControl_5, c_TakeControl_6, c_TakeControl_7 , c_TakeControl_8 , c_TakeControl_9 are chat nodes.

Instead of preparing c_TakeControl_4: do nothing.

Instead of giving link to c_TakeControl_2: say "Yes, I will. I accept this task.[rpo]".
Instead of giving text for c_TakeControl_2: say "Great! I [i]knew[r] I could count on you. Let us move on, then, for great things are about to happen. I think you will find his will perfectly attuned to yours.".

Instead of giving link to c_TakeControl_3: say "No, I will not. I cannot accept this task.[rpo]".
Instead of giving text for c_TakeControl_3: say "But why not? I tell you, this man is in pain and in danger. He needs you!".
Instead of finding responses to c_TakeControl_3: link to c_TakeControl_4; link to c_TakeControl_5; link to c_TakeControl_6; link to c_TakeControl_7; link to c_TakeControl_8; link to c_TakeControl_9.

Instead of giving link to c_TakeControl_4: say "Yeah, whatever. You can talk all night, but I'm not going to do this. Guys that are locked in cages hanging above lakes of lava? Let them sort out their own problems. That's what my mother always used to say. So goodbye, mister 'Speaker', and I hope we never meet again. [b](Warning: this option will Quit the game!)[r][rpo]".
Instead of giving text for c_TakeControl_4: say "Untold millions will suffer for your choices. But you will not lose any sleep over that, I am sure.".
Instead of finding responses to c_TakeControl_4: wait for any key; follow the immediately quit rule.


Instead of giving link to c_TakeControl_5: say "He must make his own choices. He is surely a criminal searching for redemption; but what good is a redemption unearned? The responsibility of free will cannot be shirked.[rpo]".
Instead of giving text for c_TakeControl_5: deactivate c_TakeControl_5; activate c_TakeControl_4; say "True! But your relation to him will be such that you and he are both fully responsible, both in control, and yet both unable to make the slightest move without one another. You must help him. You choices [italic type]are[roman type] his choices, and his redemption will also be yours. Please reconsider.".
Instead of finding responses to c_TakeControl_5: link to c_TakeControl_4; link to c_TakeControl_5; link to c_TakeControl_6; link to c_TakeControl_7; link to c_TakeControl_8; link to c_TakeControl_9.


Instead of giving link to c_TakeControl_6: say "I cannot guide this wretch to redemption. I am hardly a saint myself. This is surely beyond my power; my mistakes would blacken his soul even further.[rpo]".
Instead of giving text for c_TakeControl_6: deactivate c_TakeControl_6; activate c_TakeControl_4; say "You don't have to be a saint to give others advice! Indeed, I strongly suspect that most saints would just say 'Repent, sinner!' and then go on with their asceticism. Not really the kind of advice a man who stands in the middle of life can work with, is it?[pb]But anyway, you should not fear too much. Without your help, the Prisoner is doomed for certain. You cannot make it any worse, only better. That is a comforting thing to know, isn't it?".
Instead of finding responses to c_TakeControl_6: link to c_TakeControl_4; link to c_TakeControl_5; link to c_TakeControl_6; link to c_TakeControl_7; link to c_TakeControl_8; link to c_TakeControl_9.

Instead of giving link to c_TakeControl_7: say "I don't like you, 'Speaker', and I don't trust you. Who knows for what reasons of your own you have brought me here? For all I know, you are the devil himself, and I will destroy the whole world by embarking on this quest.[rpo]".
Instead of giving text for c_TakeControl_7: deactivate c_TakeControl_7; activate c_TakeControl_4; say "The Devil? Nothing so grandiose, I must admit. I fear that when you finally learn my identity, it will be a bit of an anti-climax! But listen--it doesn't matter whether you like me. It doesn't even matter whether you trust me. Just look at this guy, and ask yourself whether you want to help him. I and my motives must surely pale compared to his misery.".
Instead of finding responses to c_TakeControl_7: link to c_TakeControl_4; link to c_TakeControl_5; link to c_TakeControl_6; link to c_TakeControl_7; link to c_TakeControl_8; link to c_TakeControl_9.

Instead of giving link to c_TakeControl_8: say "All right. I will help this man, but I have to admit that I don't really understand what I'm getting myself into. I hope I won't rue this decision.[rpo]".
Instead of giving text for c_TakeControl_8: deactivate c_TakeControl_8; say "Great! I [i]knew[r] I could count on you. Let us move on, then, for great things are about to happen. I think you will find his will perfectly attuned to yours.".

Instead of giving link to c_TakeControl_9: say "Okay, I will do it. But only because I desire to help this man here, mind you, not because I like you or trust you or want to be a part of any scheme you have thought up.[rpo]".
Instead of giving text for c_TakeControl_9: say "Great! I [i]knew[r] I could count on you. Let us move on, then, for great things are about to happen. I think you will find his will perfectly attuned to yours.".


[Miscellaneous actions in the cage]

Instead of jumping in In a Cage above the Magma:
	turn off suggestion 20;
	if the player is the prisoner, say "Hindered by the size of the cage and the weakness of his muscles, the Prisoner manages no more than a little hop. Still, it sets the cage swinging and he has to grab hold of the bars in order to remain standing[if Samael is enclosed by the location]. Samael is apparently unaffected by the movements--he remains at the exact same spot while the bottom of the cage moves underneath him[end if].".


Chapter - Samael

Samael is a man. Samael is scenery.

Instead of examining Samael:
	say "What visual impressions combine and form the idea of wisdom, the idea of love, the idea of a personality so deep and vast that you could sink into it and disappear without trace? How could sight, even with the help of auditory or olfactory cues, disclose those attributes in a single instant? And yet it does.".

[Making him appear]

Making Samael appear is an activity.

Rule for making Samael appear:
	move Samael to In a Cage above the Magma;
	turn on suggestion 23; turn on suggestion 24;
	say "Suddenly, there is a [b]flash of light[r] and the sound of space collapsing. The Prisoner recoils from it, cowers in fear...";
	schedule Samael talking in two minutes;
	cancel all scheduled making Samael appear;
	consider the scene changing rules;
	try looking.

[Samael starting a conversation]

Samael talking is an activity.

Rule for Samael talking:
	run a conversation from c_samael_first_1.

[Samael first conversation]

c_samael_first_1, c_samael_first_2, c_samael_first_3, c_samael_first_4, c_samael_first_5, c_samael_first_6, c_samael_first_7 , c_samael_first_8 , c_samael_first_9, c_samael_first_10, c_samael_first_11, c_samael_first_12, c_samael_first_13, c_samael_first_14, c_samael_first_15 are chat nodes.

Instead of giving text for c_Samael_first_1: say "'I have come,' Samael tells the Prisoner. 'Do not be afraid, for I come as a friend. The time has come for you to leave this place and pursue higher goals.'".
Instead of finding responses to c_Samael_first_1: link to c_samael_first_2; link to c_samael_first_3.

Instead of giving link to c_Samael_first_2: say "Remain crouched, in a posture of submission.[rpo]".
Instead of giving text for c_Samael_first_2: say "The prisoner huddles in a corner of the cage, casting no more than furtive glances at Samael's feet. The angle smiles. 'Friend,' he says, 'I would pull you up and embrace you, had I been able to come here in my material form--but my powers are limited, and the resistance here is too great.'".
Instead of finding responses to c_Samael_first_2: link to c_samael_first_4; link to c_samael_first_5; link to c_samael_first_6.

Instead of giving link to c_Samael_first_3: say "Raise your head. Look him in the eye.[rpo]".
Instead of giving text for c_Samael_first_3: say "The prisoner raises himself with some difficulty, but dares not yet look at Samael's face, as if too afraid that he might yet turn out to be someone different. The angle smiles. 'Friend,' he says, 'I would pull you up and embrace you, had I been able to come here in my material form--but my powers are limited, and your world has become ever more resistant to my attempts to influence it.'".
Instead of finding responses to c_Samael_first_3: link to c_samael_first_4; link to c_samael_first_5; link to c_samael_first_6.

Instead of giving link to c_Samael_first_4: say "Try to touch the angel.[rpo]".
Instead of giving text for c_Samael_first_4: say "Slowly, the Prisoner extends his arm towards the radiant figure before him. Just before his finger tips will touch Samael's robes he hesitates; it seems as if he will retract his hand; but then the angel speaks: 'Come on, try it out! No harm will come to you.' The Prisoner moves to grab Samael's robes, but his fingers move right through. He looks up in uncomprehending wonder.[lb]'As I said, I am not here incarnated; what you see and hear is only a projection of my mind. How much could I do for you if I truly stood next to you! As it is, I will only be able to assist you in your escape.'".
Instead of finding responses to c_Samael_first_4: link to c_samael_first_7; link to c_samael_first_8.

Instead of giving link to c_Samael_first_5: say "[lbr]Whispered[rbr] 'Thank you for coming, master.'[rpo]".
Instead of giving text for c_Samael_first_5: say "The Prisoner's voice is hardly audible. 'Please,' says Samael, 'forget the formalities. I am not your master. Only the Emperor once had you bound by oaths, but those were formally severed when he confined you to this infernal cell. No, I am not your master, nor shall you ever be my servant. I have come here to assist you in your escape.'".
Instead of finding responses to c_Samael_first_5: link to c_samael_first_7; link to c_samael_first_8.

Instead of giving link to c_Samael_first_6: say "'Please, Samael, will you help me escape? As you promised me?'[rpo]".
Instead of giving text for c_Samael_first_6: say "'I will, my friend,' the angel says benignly. 'You have suffered enough. Enough? You have suffered far too much, more than anyone can expect of a human. Do not be ashamed of your present state--few others would have stayed as sane as you did under these circumstances.' With a gesture he indicates the cage, the lava, the subterranean prison. 'I will assist you in your escape.'".
Instead of finding responses to c_Samael_first_6: link to c_samael_first_7; link to c_samael_first_8.

Instead of giving link to c_Samael_first_7: say "'O Samael, thank you, thank you! You are my saviour!'[rpo]".
Instead of giving text for c_Samael_first_7: say "'Your saviour? Well. Maybe.' Sad eyes shine above a gentle smile. 'And maybe you will once curse me as the cause of your total damnation. Who can tell in advance? I, for all my powers, cannot pierce the screen that separates us from our future any better than you can. Still--none of that should be our concern now. Let me assess the situation and determine the best means for your escape.'[lb]With those words the angels starts examining the cage around him."; schedule Samael examining the cage part one in one minute.

Instead of giving link to c_Samael_first_8: say "'Yes! But how? How can you get me out of this infernal cell if you cannot even touch the cage with your body?'[rpo]".
Instead of giving text for c_Samael_first_8: say "'A good, practical question! Let me assess the situation and determine the best means for your escape.'[lb]With those words the angels starts examining the cage around him."; schedule Samael examining the cage part one in one minute.

Samael examining the cage part one is an activity.
Samael examining the cage part two is an activity.
Samael examining the cage part three is an activity.
Samael examining the cage part four is an activity.

Rule for Samael examining the cage part one:
	say "Samael bends towards the metal bars, as if to carefully measure their thickness.";
	schedule Samael examining the cage part two in one minute.

Rule for Samael examining the cage part two:
	say "Samael turns around and stands for a while, surveying the molten rock and the balustrade on which the only door into this hall opens.";
	schedule Samael examining the cage part three in one minute.

Rule for Samael examining the cage part three:
	say "With his insubstantial body Samael half-simulates a jumping motion, as if to better gauge the distance between the cage and the platform.";
	schedule Samael examining the cage part four in one minute.

Rule for Samael examining the cage part four:
	say "A new conversation starts now.".



Volume - New Grammar

Chapter - Maybe/Perhaps

Saying maybe is an action applying to nothing. Understand "perhaps" and "maybe" and "perhaps not" and "maybe not" and "sometimes" as saying maybe.

Carry out saying maybe:
	say "There is in his mind no certainty.". 


Chapter - Synonyms for enter

Understand "walk on [something]" as entering.



Volume - Methods, Routines, Activities

Chapter - Yes, No, Maybe

The Yes or No Boolean is a truth state that varies. The Yes or No Boolean is false.

The Yes or No Text is a text that varies. The Yes or No Text is "Please--just answer the question. Yes, no, maybe.".

The Yes or No Number is a number that varies. The Yes or No Number is 0.


First instead of doing anything except saying yes, saying no or saying maybe when the Yes or No Boolean is true:
	if gs_PlayerHelp_Stage is -1, do nothing instead;
	say the Yes or No Text.


Chapter - Getting the Player Started

[We want to help the player get through the first few moves by suggesting actions she can take. This will make the game MUCH more accessible to novice players.

We will make a table with suggestions. Suggestions have a dial, which is either 1 or 0. If the dial is 1, the suggestion will be shown, If it is 0, it will not be shown. Suggestions have a unique number called their ID. And suggestions have a number called follow-up and a number called activated. When a suggestion is followed, it is turned off, and the suggestion with an ID of follow-up will be turned on. The follow-up will be marked activated. An activated suggestion will not be turned on again, if some other suggestion also has it as a follow up.]

Table of Suggestions
Suggestion				ID	      Dial	      Activated		Follow-up			Second Follow-up
"examine lake"			4	       1		0			7				12
"examine me"			5	       1		0			6				0
"look"					6	       0		0			11				8
"examine patterns"		7	       0		0			8				9
"examine cage"			8	       0		0			10				0
"smell air"				9	       0		0			11				0
"examine Prisoner"		10	      0	       0			0				0
"examine mountains"		11	      0		0			0				0
"listen to the magma"	   12		0	       0			0				0
"examine prisoner"		13		0		0			16				0
"examine patterns"		19		0		0			0				0
"smell prisoner"			16		0		0			0				0
"examine cage"			  15		0		0			17				0
"examine bars"			  17		0		0			0				0
"listen to prisoner"		18		0		0			0				0
"examine magma"		  14		0		0			19				0
"jump"					20		0		0			0				0
"attack bars"			21		0		0			0				0
"examine me"			22		0		0			0				0
"examine Samael"		23		0		0			0				0
"talk to Samael"			24		0		0			0				0

[We want a boolean to track whether the player has turned off help, and a command that let's him do so..]

gs_PlayerHelp is a truth state that varies. gs_PlayerHelp is true.

Turning off help is an action out of world. Understand "turn off help" and "help off" as turning off help.

Carry out turning off help:
	say "[italic type](Okay, I'm now turned off. You can turn me back on by typing 'help on'.)[roman type][line break]";
	now gs_PlayerHelp is false.
	
Turning on help is an action out of world. Understand "turn on help" and "help on" as turning on help.

Carry out turning on help:
	say "[italic type](Okay, I'm turned on again.)[roman type][line break]";
	now gs_PlayerHelp is true.


[And a number to track the state of the player in having been given help.]

gs_PlayerHelp_Stage is a number that varies. gs_PlayerHelp_Stage is -1.

[Now, the rule that ensures that the right stuff is written just before the command line. Note that ONLY whether we actually write something is conditional on the state of gs_Player_Help. Turning stuff on and off, and advancing the help stage happens even when gs_PlayerHelp is false. This ensures that we can turn it on again whenever we want.]

Before reading a command:
	if gs_PlayerHelp_Stage is 10:
		if gs_PlayerHelp is true, show the help suggestions;
	if gs_PlayerHelp_Stage is 9:
		say "[italic type](It's good to see that you could make it through those numbered menus without my help! What you need to understand is that from now on, your commands will correspond with things the Prisoner does. So if you type 'jump', the Prisoner will jump. If you type 'attack bars', he will attack the bars. Just try it out.)[roman type][line break]";
		repeat with n running from 4 to 18:
			turn off suggestion n; [Suggestions for the first scene turned off]
		repeat with n running from 19 to 22:
			turn on suggestion n; [Suggestions for second scene turned on]
		now gs_PlayerHelp_Stage is 10;
	if gs_PlayerHelp_Stage is 8:
		if gs_PlayerHelp is true, say "[italic type](He's asking you a question again. Remember, just type 'yes', 'no', or 'maybe'.)[roman type][line break]";
	if gs_PlayerHelp_Stage is 7:
		if gs_PlayerHelp is true, show the help suggestions;
	if gs_PlayerHelp_Stage is 6:
		if gs_PlayerHelp is true, say "[italic type](Okay, I'm going to turn myself off now, so you can try playing without my guidance for a short while. If you get stuck and really need me, just type 'help on'. We'll see each other in a minute.)[roman type][line break]";
		now gs_PlayerHelp is false;
		now gs_PlayerHelp_stage is 7;
	if gs_PlayerHelp_Stage is 4:
		if gs_PlayerHelp is true, show the help suggestions;
	if gs_PlayerHelp_Stage is 5:
		if gs_PlayerHelp is true, say "[italic type](Good. When the Speaker gives you a description of something you've examined, he will often mention objects that he didn't mention before. Here, for instance, he speaks about 'patterns' in the magma. So what you may want to do now is to type 'examine patterns'.)[roman type][line break]";
		now gs_PlayerHelp_stage is 4;
	if gs_PlayerHelp_Stage is 3:
		if gs_PlayerHelp is true, say "[italic type](Excellent! Of course, it wasn't really useful this time, since he just told you where you were; but it will come in handy later. Okay, so let's move to the second lesson. You can use the 'examine' command to take a specific look at objects in the location. Here, for instance, there is a lake of boiling magma, so try typing 'examine lake'.)[roman type][line break]";
		now gs_PlayerHelp_Stage is 4;
	if gs_PlayerHelp_Stage is 2 and gs_PlayerHelp is true, say "[italic type](Just type 'look'. It's the command that let's you survey your surroundings. Oh, by the way: if you already know your way around in interactive fiction, you can turn me off my typing 'help off'.)[roman type][line break]"; 		if gs_PlayerHelp_Stage is 1:
		if gs_PlayerHelp is true, say "[italic type](Very good! You have followed the Speaker into the world where the story you must tell together takes place. He will tell you about that world, and you can tell him what you want to do. You'll have to use the right commands, but don't worry: I will slowly introduce you to them. So here is your first lesson: if you want the Speaker to redescribe your surroundings, type 'look'. Try it out now and see for yourself.)[roman type][line break]";
		now gs_PlayerHelp_Stage is 2;
	if gs_PlayerHelp_Stage is 0:
		if gs_PlayerHelp is true, say "[italic type](As you see, the Speaker is not going to let you get away with not answering his question! Just type 'yes', 'no', or 'maybe'.)[roman type][line break]";
	if gs_PlayerHelp_Stage is -1:
		now gs_PlayerHelp_Stage is 0;
		if gs_PlayerHelp is true, say "[italic type](See? You can trust me. I've known this guy like for ages. Anyway, you've probably gathered by now that he is obsessed by angels, and he wants to know whether you believe that they listen to us. You can respond by typing 'yes', or 'no', or 'maybe'. Choose whichever you like--this isn't a quiz, the Speaker is interested in your honest opinion.)[roman type][line break]".


[A routine to show the suggestions.]
	
To show the help suggestions:
	now the first dummy is 0;
	repeat through the Table of Suggestions begin;
		if the Dial entry is 1, increase the first dummy by 1;
	end repeat;
	if the first dummy is zero begin;
		say "[italic type](I'm sorry; I haven't got any suggestions at the moment.)[roman type][line break]";
	otherwise;
		say "[italic type](Some things you could try to do are: ";		
		repeat through the Table of Suggestions begin;
			if the Dial entry is 1 begin;
				say "'[Suggestion entry]'";
				if the first dummy is greater than 1, say ", ";
				decrease the first dummy by 1;
			end if;
		end repeat;
		say ".)[roman type][line break]";
	end if.

[And a routine that can be called to turn off suggestions once they've been tried.]

To turn off suggestion (N - a number):
	choose a row with ID of N in the Table of Suggestions;
	now the Dial entry is 0;
	now the Activated entry is 1;
	if the follow-up entry is not 0:
		choose a row with ID of follow-up entry in the Table of Suggestions;
		if the Activated entry is 0, now the Dial entry is 1;
		now the Activated entry is 1;
	if the second follow-up entry is not 0:
		choose a row with ID of second follow-up entry in the Table of Suggestions;
		if the Activated entry is 0, now the Dial entry is 1;
		now the Activated entry is 1.

To turn on suggestion (N - a number):
	choose a row with ID of N in the Table of Suggestions;
	now the Dial entry is 1.


Volume - The System


Volume - Temp
[
Rule for deciding whether to allow undo:
		if the player is not yourself begin;
			say "You cannot undo now.";
			deny undo;
		end if.

]
